/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: netX.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    netX General Definitons

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-03-24  File created.

**************************************************************************************/


#ifndef __NETX_H
 #define __NETX_H

  #define NETX_XPEC_MEM_SIZE 2048 /* Size of an xPEC memory is 2048 D-WORDS */

    /* Structure defintion of the Bootblock */
  typedef struct NETX_BOOTBLOCK_Ttag {
    UINT32 ulMagCok;

    union {
      UINT32 ulMemCtrl;
      UINT32 ulSpeed;
      UINT32 ulRes;
    } unCtrl;

    UINT32 ulAppEnt;
    UINT32 ulAppChksm;
    UINT32 ulAppFilSiz;
    UINT32 ulAppSrtAdd;
    UINT32 ulSignt;
    union {
      UINT32 ulSdramGeneralCtrl;
      UINT32 ulExpBusReg;
    } unCtrl0;
    union {
      UINT32 ulSdramTimingCtrl;
      UINT32 ulIoRegMode0;
    } unCtrl1;
    union {
      UINT32 ulIoRegMode1;
      UINT32 ulRes0;
    } unCtrl2;
    union {
      UINT32 ulIfConf1;
      UINT32 ulRes0;
    } unCtrl3;
    union {
      UINT32 ulIfConf2;
      UINT32 ulRes0;
    } unCtrl4;
    UINT32 ulMiscAsicCtrl;
    UINT32 ulUserData;
    UINT32 ulSrcType;
    UINT32 ulBootChksm;
  } NETX_BOOTBLOCK_T;

#endif
